<?php
/*  Copyright 2009-2018 Youngwhan Song  (email : breadncup@gmail.com)

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

if ( !defined('ABSPATH') ) exit;
require(dirname( __FILE__ ).'/yw-latex-settings.php');

class YW_LATEX_ADMIN extends YW_LATEX {
    function yw_admin_init() {
        parent::yw_init();
        add_action('admin_menu', array(&$this,'yw_admin_option'));
        $this->yw_latex_checkCGI();
    }
    function yw_admin_option() {
        add_options_page('Youngwhan\'s Simple Latex Plugin Options', 'YW Latex', 10, dirname( __FILE__ ).'/yw-latex-options.php');
    }
    function yw_latex_addActionLink($links) {
        $links[]=sprintf('<a href="%s">%s</a>', admin_url('options-general.php?page='.dirname(plugin_basename( __FILE__ )).'%2Fyw-latex-options.php'), __('Settings', "Youngwhan's Simple Latex")); 
        $links[]=sprintf('<a href="https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=HU2K7TG9EXVDW&source=url">%s</a>', __('Donation', "Youngwhan's Simple Latex"));
        return $links;
    }
    function yw_latex_errMsg($var,$text) {
        $retText="";
        if (empty($var)) {
            $retText="There is no ".$text." installed in the system.<br />";
        } else {
            $retText="Found ".$text." tool in the system.<br />";
        }
        return $retText;
    }

    function yw_latex_checkCGI() {
        global $yw_latex_gMsg;
        $yw_latex_gMsg="";

        require_once(dirname( __FILE__ ).'/yw-latex-settings.php');
        $mathtexurl = YW_LATEX_SETTINGS::instance()->get(YW_LATEX_SETTINGS::KEY_LOCATIONCGI);
        if (empty($mathtexurl)) {
            $pluginDir=plugin_dir_path( __FILE__ );
            $cgiFile="mathtex.cgi";
            if (!file_exists($pluginDir.$cgiFile)) {
                $latex=trim(shell_exec('which latex'));
                if (empty($latex)) {
                    $yw_latex_gMsg="Failed to install the cgi.<br />";
                    $yw_latex_gMsg.=$this->yw_latex_errMsg($latex,"latex");
                    return;
                }
                $dvipng = trim(shell_exec('which dvipng'));
                $cmd="/usr/bin/cc ".$pluginDir."mathtex.c -DLATEX=\\\"".$latex."\\\"";
                if (empty($dvipng)) {
                    $dvips = trim(shell_exec('which dvips'));
                    $convert = trim(shell_exec('which convert'));
                    if (empty($dvips) || empty($convert)) {
                        $yw_latex_gMsg="Failed to install the cgi.<br />";
                        $yw_latex_gMsg.=$this->yw_latex_errMsg($dvipng,"dvipng");
                        $yw_latex_gMsg.=$this->yw_latex_errMsg($dvips,"dvips");
                        $yw_latex_gMsg.=$this->yw_latex_errMsg($convert,"convert");
                        return;
                    }
                    $cmd.=" -DDVIPS=\\\"".$dvips."\\\"";
                    $cmd.=" -DCONVERT=\\\"".$convert."\\\"";
                } else {
                    $cmd.=" -DDVIPNG=\\\"".$dvipng."\\\"";
                }
                $cmd.=" -o ".$pluginDir.$cgiFile;
                $result=shell_exec($cmd);
            }
            $location=plugins_url()."/".dirname(plugin_basename( __FILE__ ))."/mathtex.cgi";
            YW_LATEX_SETTINGS::instance()->updateOption(YW_LATEX_SETTINGS::KEY_LOCATIONCGI, $location);
        }
    }
}
?>
