<?php
/*  Copyright 2009-2018 Youngwhan Song  (email : breadncup@gmail.com)

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

class YW_LATEX_SETTINGS {
    private static $kInstance = null;

    const KEY_VERSION="yw_latex_version";
    const KEY_LOCATIONCGI="yw_latex_mathtex";

    const DBCLEANUP_VER=1.61;
    const CURRENT_VER=1.62;

    private $settingsArray = array(
        self::KEY_VERSION => self::CURRENT_VER
    );

    public function deleteOptions() {
        foreach($this->settingsArray as $key => $value) {
            delete_option($key);
        }
    }

    private function addOptions() {
        foreach($this->settingsArray as $key => $value) {
            add_option($key, $value);
        }
    }
    
    private function getOptions() {
        foreach($this->settingsArray as $key => $value) {
            $this->settingsArray[$key] = get_option($key);
        }
    }

    public function updateOption($key, $value) {
        if (array_key_exists($key, $this->settingsArray)) {
            update_option($key, $value);
            $this->settingsArray[$key] = $value;
        }
    }
    
    public function __construct() {
        if (!array_key_exists(self::KEY_LOCATIONCGI, $this->settingsArray)) {
            $existingOption=get_option(self::KEY_LOCATIONCGI);
            $this->settingsArray[self::KEY_LOCATIONCGI] = $existingOption;
            // if (!empty($existingOption)) {
            //     $this->settingsArray[self::KEY_LOCATIONCGI] = $existingOption;
            // }
        }
        $dbVer = get_option(KEY_VERSION);
        if (empty($dbVer) || $dbVer < DBCLEANUP_VER) {
            $this->deleteOptions();
        }
        $this->addOptions();
        $this->getOptions();
    }

    public static function instance() {
        // no instance defined yet, load it
        if (self::$kInstance === null) {
            self::$kInstance = new self();
        }
        // return a singleton of this class
        return self::$kInstance;
    }

    public function get($key) {
        return array_key_exists($key, $this->settingsArray) ? $this->settingsArray[$key] : null;
    }
}
?>
