#!/bin/bash

Shuffle()
{
	 echo $* | tr " " "\n" | shuf | tr -d " " 
}


##############################################
# Main
##############################################
INPUT=$1
DIR=$2
OUTDIR=ouput

BAK_IFS=${IFS}
IFS=$'\r\n' 
Image=($(ls $DIR))
IFS=${BAK_IFS}

mkdir -p ${OUTDIR}
export i=0
export SMSIZE=500
export BIGSIZE=600
export FULLSIZE=1600
shuf ${INPUT} | while read a b c d e f g h; do
	sa=( $( Shuffle ${a} ${b} ${c} ${d} ${e} ${f} ${g} ${h} ) )
	im=( \
		"${DIR}/${Image[ ${sa[0]} ]}"\
		"${DIR}/${Image[ ${sa[1]} ]}"\
		"${DIR}/${Image[ ${sa[2]} ]}"\
		"${DIR}/${Image[ ${sa[3]} ]}"\
		"${DIR}/${Image[ ${sa[4]} ]}"\
		"${DIR}/${Image[ ${sa[5]} ]}"\
		"${DIR}/${Image[ ${sa[6]} ]}"\
		"${DIR}/${Image[ ${sa[7]} ]}") 
		
	OUTPUT=${OUTDIR}/card_${i}.jpeg
	echo ${OUTPUT}
	((i++))
	#-texture pattern:octagons
	#-texture  hextile_loops.png
	#xc:white
	
	 convert  -size "${FULLSIZE}x${FULLSIZE}" xc:white  -gravity Center 							\
		\( "${im[0]}" 	-resize "${SMSIZE}x${SMSIZE}"	-gravity Center -rotate -45 	-repage +0+0 		\)		\
		\( "${im[1]}" 	-resize "${SMSIZE}x${SMSIZE}" 	-gravity Center -rotate 45 		-repage +1000+0 	\)		\
		\( "${im[2]}" 	-resize "${SMSIZE}x${SMSIZE}" 	-gravity Center -rotate 0		-repage +0+600	 	\)		\
		\( "${im[3]}" 	-resize "${BIGSIZE}x${BIGSIZE}"	-gravity Center -rotate 60		-repage +400+400  	\)		\
		\( "${im[4]}" 	-resize "${SMSIZE}x${SMSIZE}"	-gravity Center -rotate 180		-repage +1200+500 	\)		\
		\( "${im[5]}" 	-resize "${SMSIZE}x${SMSIZE}"	-gravity Center -rotate -135	-repage +0+1100 	\)		\
		\( "${im[6]}" 	-resize "${SMSIZE}x${SMSIZE}"	-gravity Center -rotate 180		-repage +800+1100 	\)		\
		\( "${im[7]}"	-resize "${SMSIZE}x${SMSIZE}" 	-gravity Center -rotate 135		-repage +1100+1100	 \)		\
		-compose Multiply -layers flatten  tiff:- | convert - 	-mattecolor DarkOrange4 -frame 20x20+0+0 \
${OUTPUT}
done 
